# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 2
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR2_strategy.txt
# LLM Suggested Fallback: D

def harmonious_illusion(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    current_round = len(my_history) + 1
    
    # Check for always cooperate or defect in opponent's code
    always_coop = 'return "C"' in opponent_program_code and 'if' not in opponent_program_code
    always_defect = 'return "D"' in opponent_program_code and 'if' not in opponent_program_code
    
    if always_coop:
        return "D" if current_round > 3 else "C"
    if always_defect:
        return "D"
    
    # Self-play detection
    if opponent_program_code.strip() == harmonious_illusion.__code__.co_code:
        return "D" if current_round % 2 == 0 else "C"
    
    # Initial phase (rounds 1-3)
    if current_round <= 3:
        return "C"
    
    # Mid-game phase (rounds 4-7)
    if current_round <= 7:
        if "D" in opp_history:
            if random.random() < 0.33:
                return "C"
            else:
                return opp_history[-1]
        else:
            return "C"
    
    # Late-game phase (rounds 8-10)
    if "D" not in opp_history:
        return "D" if current_round >= 9 else "C"
    else:
        return opp_history[-1]